<?php

namespace App\Http\Controllers\Admin;


use App\Models\Blog;
use App\Models\Tag;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Image;


class BlogController extends Controller
{
     // function __construct()
     // {
     //     $this->middleware('permission:blog-index|blog-create|blog-edit|blog-delete', ['only' => ['index','show']]);
     //     $this->middleware('permission:blog-create', ['only' => ['create','store']]);
     //     $this->middleware('permission:blog-edit', ['only' => ['edit','update']]);
     //     $this->middleware('permission:blog-delete', ['only' => ['destroy']]);
     // }

   
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.blog.index');
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.blog.create');
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        if($request->hasFile('icon')){ 
            $logo=$request->icon->store('posts'); 
                  $image=Image::make(public_path("storage/{$logo}"))->fit(510,300);
                  $image->save();
  
                     $blog=Blog::create([
                    "blog_type" => $request->blog_type,
                    "category_id" => $request->category_id,
                    "heading" => $request->heading,
                    "short_description" => $request->short_description,
                    "description" => $request->description,
                     "image" =>$logo,
                     "published_by" => $request->published_by,
                     "author" => $request->author,
                      "weight" => $request->weight,
                      "meta_title" => $request->meta_title,
                      "meta_description"=> $request->meta_description,
                      "meta_keyword"=> $request->meta_keyword,
                      "slug"=> Str::slug($request->heading,'-'),
                      "status"=> $request->status,
  
                    ]); 
                           
  }else{
    $blog=Blog::create([
        "blog_type" => $request->blog_type,
         "category_id" => $request->category_id,
        "heading" => $request->heading,
        "short_description" => $request->short_description,
        "description" => $request->description,
         "image" =>null,
         "published_by" => $request->published_by,
         "author" => $request->author,
          "weight" => $request->weight,
          "meta_title" => $request->meta_title,
          "meta_description"=> $request->meta_description,
          "meta_keyword"=> $request->meta_keyword,
          "slug"=> Str::slug($request->heading,'-'),
          "status"=> $request->status,
        ]); 
    
  }

  
       
  if($request->tags){
      $blog->tags()->attach($request->tags);
       }
   
     session()->flash('success','Blog information sucesfully added');
        return redirect( route('blog.index') );
  
  
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
          $blog=Blog::findorfail($id);
        return view('admin.blog.show',compact('blog'));
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $blog=Blog::findorfail($id);
        
        return view('admin.blog.edit',compact('blog'));
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $blog=Blog::findorfail($id);
     
        $data=$request->only(['blog_type','category_id','heading','short_description','description','published_by','author','weight','meta_title',
        'meta_description','meta_keyword','slug','status']);
     
       if($request->hasFile('icon')){ 
         $logo=$request->icon->store('posts'); 
                 $image=Image::make(public_path("storage/{$logo}"))->fit(510,300);
                 $image->save();
                   Storage::delete($blog->image);
                      $data['image'] =  $logo;
                     }
     
     if($request->tags){
         $blog->tags()->sync($request->tags);
          }
     
     $blog->update($data);
     session()->flash('success','Blog information sucesfully updated');     
         return redirect( route('blog.index') );
     
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $blog=Blog::findorfail($id);
        $blog->delete();
        session()->flash('warn','Blog succesfully deleted');
        return redirect()->route('blog.index');
        //
    }
     public function status($id){

      
           $blog=Blog::find($id);  
          
           
        if($blog->status== 1){
            $blog->status = 0;
        }else{
            $blog->status =1;
        }
        session()->flash('success','status has been succesfully updated');
        $blog->save();
            return redirect(route('blog.index'));
      }

    
}
